;
;
;

org 100h ; ax=bx=0 ch=0 si=0x100 sp=di=-2

; 55                push bp
; 3F                aas
; 5F                pop di
; 40                inc ax
; 01904086          add [bx+si-0x79c0],dx
; 3F                aas

;  jmp S     ; [si]=C:3.50023913
;C5div6 dd 0.833333333333
C5div6 equ $-2
  db 0x55,0x3F

  db 0x5F
C320 dw 320 ; 0x40,1
;C4_5 dd 4.5
C4_5 equ $-2
  db 0x90, 0x40
C2PIdiv6 equ $-2
  db 0x86, 0x3f ; 1.04884529, good enough (2π/6 = 1.047197551)

%define W(x) word[byte si-100h+x]
%define D(x) dword[byte si-100h+x]

S lfs cx,[si+4] ; cx:T, fs=0x4086
  push 0xa000-640/16  ; hide top two rows
  pop es
  mov al,13h  ; 320x200
  int 10h

X xor dx,dx   ; dx=0
  mov ax,di
  div W(C320)

  ;mov ax,0xcccd
  ;mul di
  ;xchg ax,cx

  sub dx,160  ; dx=X  ; -160..160
  sub ax,100  ; ax=Y  ; -100..100
  pusha   ;[bx-10 -8 -6 -4]
          ;    bx dx cx ax
          ;     0  X  T  Y
  fild word[bx-4]
  fmul st0        ; x²
  fild word[bx-8]
  fmul st0        ; y² x²
  faddp           ; x²+y²
  fsqrt           ; r=√(x²+y²)      ; 0..100 vertically

  fild word[bx-8]
  fild word[bx-4]
  fpatan          ; a=atan2(x,y) r  ; -π..π

; aad is slow to emulate
  mov ax,7*256 + 32+24+24+24+19+24
  and ah,ch
  aad 3 ; al += 3*ah

  shl ch,6  ; 00000uvw -> cf=u sf=v pf=v^w
  jc C
  
;  fild word[bx-6]
;  fidiv W(C320)
;  faddp

;Hexagon / star / sun
A jnp B
  fdiv D(C2PIdiv6)  ; a/Q r           ; Q = 2π/N
  jns F           ; Star: 5 points instead of 6
  fmul D(C5div6)
F fist word[bp+si]
  fisub word[bp+si] ; fract(a/Q)-0.5 r
  jns E
  fadd st0        ; Star: more pointy
E fmul D(C2PIdiv6)  ; s=Q*(fract(a/Q)-0.5) r
  fcos
  jmp J             ; R=r*cos(s)

;Clover: C / (C - cos(4.5 sin(2a)));
C jnp G
  fadd st0        ; 2a r
  jns D
  fsin

;Flower with 9 petals / butterfly
G fmul D(C4_5)
  fcos
  fchs
  js I
  fabs
  jmp I

;Gear: C / (C + sin(cos(7a) + 2C)) ; 2C-2π ≈ π/4
B fmul dword[si]  ; Gear (7 points)
  jns F           ; Sun (22 points)
  fadd st0
  fcos
  fadd dword[si]  ; "fabs" is a no-op here

;Heart: C / (C + sin(|2a| + C))
D fabs            ; |2a| r
  fadd dword[si]
  fsin            ; s=sin(|2a|+C) r
I fadd dword[si]
  fdivr dword[si] ; R=r*C/(C+s)
J fmulp

P fistp word[bp+si]
  xor cl,16
  sub cl,[bp+si]
  shr cl,6        ; set cf
  jnc Q
  add al,72

; shading
Q mov bx,-640
  mov [fs:di],al
Y cmp al,[fs:di+bx]
  jae Z
  sub al,48
Z sar bx,8
  jnp Y

  stosb
  popa

  inc di
M jnz X

;  mov dx,0x3da  ; vsync
;V in al,dx
;  test al,8
;  jz V

  pusha
  mov bl,cl     ; bh=0
  and cx,7
  jnz SKIPMIDI

  mov si,MIDI
;  mov dl,0x31   ; MIDI control port
  mov dx,0x331   ; MIDI control port
  outsb         ; uart
  dec dx        ; MIDI data port

  mov cl,9
  xor byte[si+1],36^42
  rep outsb

  shr bx,5
  xor byte[bx+si],32
  mov al,[bx+si]
  out dx,al
  mov al,0x7f
  out dx,al
;  outsb
;  ror dword[si],4
;  lodsb
;  and al,0xf
;  add al,32+24
;  out dx,al
;  outsb

  ;mov al,0x4
 ; and al,ah
;  shl al,4
;  mov al,0x40

;  out dx,al

SKIPMIDI:
  popa
  inc cx  ; t++

  in al,60h  ; ax=100
  dec ax
  jnz M
  ret

MIDI:
  db 0x3f ; uart

  db 0x99, 36, 0x7f ; bass drum

  db 0xc0, 81       ; ch1 instrument: saw
  db 0xb0, 123, 0   ;     notes off

  db 0x90           ;     play notes

  %define TR 32

;  dd 0x8507587F    ; melody

  db TR+0,TR+1,TR+1,TR+1,TR+5,TR+5,TR+3,TR+3  ; base notes

